//libraries

  #include <Servo.h>                   //Servo library

  #include <Keypad.h>                  //Keypad library

  #include <MFRC522.h>                 //RFID library
  #include <SPI.h>

  #include <LiquidCrystal_I2C.h>       //LCD library
  #include <Wire.h>

  #include <Bridge.h>
  #include <HttpClient.h>

  char buffer[4];
  int dil=1;
 

 #include <SPI.h>  
#include "RF24.h"

RF24 myRadio (9, 53);
byte addresses[][6] = {"0"};

struct package {
  int id = 1;
  float variable = 1.5;
  char  text[300] = "Text to be Text posila 2";
};


typedef struct package Package;
Package dataRecieve;
Package dataTransmit;


//entry

  Servo myservo1;          //servo 1 name 
  int pos1;                //servo 1 position

  int s1Pin = 36;      //sensor 1 pin
  int c1Pin = 48;      //control 1 senzor pin

  int ledPinG1 = 40;      //green LED 1 pin
  int ledPinR1 = 44;      //red LED 1 pin

  bool s1S;      //sensor 1 state
  bool c1S;      //control 1 sensor state

  int S1;      //inner loop 1
        
  unsigned long stoptime1;     //start timer 1 from 0 to infinity

//exit

  Servo myservo2;          //servo 2 name 
  int pos2;                //servo 2 position

  int b2Pin = 23;      //button 2 pin
  int s2Pin = 37;      //sensor 2 pin
  int c2Pin = 49;      //control 2 senzor pin

  int ledPinG2 = 41;      //green LED pin 2
  int ledPinR2 = 45;      //red LED pin 2

  bool b2S;      //button 2 state
  bool s2S;      //sensor 2 state
  bool c2S;      //control 2 sensor state

  int S2;      //inner loop 2
        
  unsigned long stoptime2;     //start timer 2 from 0 to infinity

//keypad

  const byte COLS = 4;      //4 columns
  const byte ROWS = 3;      //3 rows

  char keys[COLS][ROWS] = {      //connect characters to the rows and columns
    {'1','2','3'},
    {'4','5','6'},
    {'7','8','9'},
    {'*','0','#'}
};

  byte colPins[COLS] = {2, 3, 4, 5};       //connect to the column pinouts of the keypad
  byte rowPins[ROWS] = {6, 7, 10};      //connect to the row pinouts of the keypad

  Keypad keypad = Keypad( makeKeymap(keys), colPins, rowPins, COLS, ROWS );

  int K;      //keypad inner loop

  char A;     //password order characters
  char B;
  char C;
  char D;

  char pas1;      //password number characters
  char pas2;
  char pas3;
  char pas4;

//RFID

  #define SDA_PIN 9       //define SDA pin
  #define RST_PIN 8       //define RST pin

  MFRC522 rfid(SDA_PIN, RST_PIN);       //initialization of RFID

  int R;      //RFID inner loop

  int iR;      //RFID state

  unsigned long stoptimeR;     //start timer R from 0 to infinity

//free space counting

  int space;      //number of free space

  int max;      //max number of free space

//serial monitor

  int M;      //serial monitor inner loop

  unsigned long stoptimeM;     //start timer M from 0 to infinity

//LCD

  LiquidCrystal_I2C lcd(0x27, 20, 4);     //adress of I2C, number of rows and columns

  int L1;      //L1 inner loop
  int L2;      //L2 inner loop

  unsigned long stoptimeL;     //start timer L from 0 to infinity

void setup(){//-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    
  Serial.begin(9600);      //initialization of comunication between Arduino and computer (comunication with serial monitor)
  Bridge.begin();
  //Serial.begin(9600);
//entry

  myRadio.begin();  
  myRadio.setChannel(115); 
  myRadio.setPALevel(RF24_PA_MAX);
  myRadio.setDataRate( RF24_250KBPS );
  
  myRadio.openReadingPipe(1, addresses[0]);
  myRadio.startListening();

  pinMode(s1Pin, INPUT_PULLUP);      //pin is set to input with pullup resistor
  pinMode(c1Pin, INPUT_PULLUP);      //pin is set to input with pullup resistor

  pinMode(ledPinG1, OUTPUT);      //pin is set to output
  pinMode(ledPinR1, OUTPUT);      //pin is set to output

  myservo1.attach(26);        //servo 1 pin
  myservo1.write(pos1);       //servo 1 position

  digitalWrite(ledPinG1, 0);      //ledPinG1 is set to 0
  digitalWrite(ledPinR1, 1);      //ledPinR1 is set to 1

  S1=1;  

//exit

  pinMode(b2Pin, INPUT_PULLUP);      //pin is set to input with pullup resistor
  pinMode(s2Pin, INPUT_PULLUP);      //pin is set to input with pullup resistor
  pinMode(c2Pin, INPUT_PULLUP);      //pin is set to input with pullup resistor

  pinMode(ledPinG2, OUTPUT);      //pin is set to output
  pinMode(ledPinR2, OUTPUT);      //pin is set to output

  myservo2.attach(27);        //servo 2 pin
  myservo2.write(pos2);       //servo 2 position

  digitalWrite(ledPinG2, 0);      //ledPinG2 is set to 0
  digitalWrite(ledPinR2, 1);      //ledPinR2 is set to 1

  S2=1;

//keypad

  K=1;      //keypad inner loop

  A='_';      //set typed password to blank
  B='_';
  C='_';
  D='_';

  pas1='1';     //keypad password
  pas2='3';
  pas3='7';
  pas4='9';

//RFID

  SPI.begin();      //initialization of SPI comunication
  rfid.PCD_Init();      //initialization of comunication with RFID

  R=1;      
  iR=0;

//free space counting

  max=2;          //number of max space

  space=max;

//serial monitor

  stoptimeM=millis() +150;      //serial monitor printing speed

//LCD

  lcd.begin();          //initialization of LCD
  lcd.backlight();      //backlight on

  L1=0;
  L2=0;

}
void loop(){//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  if(buffer[dil] == '1'){
    Serial.print("cervena");
  }
  else if(buffer[dil] == '2'){
    Serial.print("zelena");  
  }
  else if(buffer[dil] == '3'){
    Serial.print("modra");
  }
  else if(buffer[dil] == '4'){
    Serial.print("zluta");
  }
  Serial.println();
  delay(100);

export1();
 
  if(buffer[dil] == '1'){
    digitalWrite(8, HIGH);
    digitalWrite(9, LOW);
    digitalWrite(10, LOW);
    digitalWrite(11, LOW);
  }
  else if(buffer[dil] == '2'){
    digitalWrite(8, LOW);
    digitalWrite(9, HIGH);
    digitalWrite(10, LOW);
    digitalWrite(11, LOW);  
  }
  else if(buffer[dil] == '3'){
    digitalWrite(8, LOW);
    digitalWrite(9, LOW);
    digitalWrite(10, HIGH);
    digitalWrite(11, LOW);
  }
  else if(buffer[dil] == '4'){
    digitalWrite(8, LOW);
    digitalWrite(9, LOW);
    digitalWrite(10, LOW);
    digitalWrite(11, HIGH);
  } 



  if(millis()>=stoptimeM){//serial monitor

                          Serial.print("Space=");      //print space
                          Serial.print(space);

                          Serial.print("     []     ");

                          //sm keypad

                          Serial.print("K=");     //print keypad loop
                          Serial.print(K);

                          Serial.print("  password = ");      //print typed password
                          Serial.print(A);
                          Serial.print(B);
                          Serial.print(C);
                          Serial.print(D);

                          Serial.print("     []     ");

                          //sm RFID

                          Serial.print("RFID = ");          

                          if(iR==0){Serial.print("_______");
                                   }

                          if(iR==1){stoptimeR=millis() +1000;     //start timer R 1s and go to iR11
                                    iR=11;
                                   }

                          if(iR==11){Serial.print("  wrong");           //print wrong, if timer R reach 0 go to iR0
                                     if(millis()>=stoptimeR){iR=0;      
                                                            }                                
                                   }

                          if(iR==2){stoptimeR=millis() +1000;       //start timer R 1s and go to iR21
                                    iR=21;
                                   }

                          if(iR==21){Serial.print("correct");           //print correct, if timer R reach zero go to iR0
                                     if(millis()>=stoptimeR){iR=0;
                                                            }                                
                                   }

                          //sm gate 1

                          Serial.print("     []     ");

                          Serial.print("S1=");      //print inner loop 1
                          Serial.print(S1);
                          Serial.print("  pos1=");      //print position 1
                          Serial.print(pos1);

                          //sm gate 2

                          Serial.print("     []     ");

                          Serial.print("S2=");      //print inner loop 2
                          Serial.print(S2);
                          Serial.print("  pos2=");      //print position 2
                          Serial.println(pos2);



                          //LCD free space

                          lcd.setCursor (0,0);
                          lcd.print("SPACE LEFT:");
                          lcd.setCursor(11,0);
                          lcd.print(space);

                          //LCD pin

                          if(L1==0){lcd.setCursor(0,2);
                                    lcd.print("PRESS * FOR PIN");
                                   }

                          if(L1==1){lcd.setCursor(0,2);
                                    lcd.print("PIN:              ");
                                    lcd.setCursor(4,2);
                                    lcd.print(A);
                                    lcd.setCursor(5,2);
                                    lcd.print(B);
                                    lcd.setCursor(6,2);
                                    lcd.print(C);
                                    lcd.setCursor(7,2);
                                    lcd.print(D);
                                    lcd.setCursor(8,2);
                                    lcd.print("       ");
                                    }

                          if(L1==2){lcd.setCursor(4,2);
                                    lcd.print("CORRECT            ");
                                    stoptimeL=millis() +7000;
                                    L1=4;
                                    }

                          if(L1==3){lcd.setCursor(4,2);
                                    lcd.print("WRONG              ");
                                    stoptimeL=millis() +1000;
                                    L1=4;
                                    }

                          if(L1==4){if(millis()>=stoptimeL){L1=0;
                                                           }
                                   }

                          //LCD RFID

                          lcd.setCursor(0,3);
                          lcd.print("RFID:");

                          if(L2==0){lcd.setCursor(5,3);
                                    lcd.print("       ");
                                   }

                          if(L2==1){lcd.setCursor(5,3);
                                    lcd.print("CORRECT             ");
                                    stoptimeL=millis() +7000;
                                    L2=3;
                                    }

                          if(L2==2){lcd.setCursor(5,3);
                                    lcd.print("WRONG               ");
                                    stoptimeL=millis() +1000;
                                    L2=3;
                                    }

                          if(L2==3){if(millis()>=stoptimeL){L2=0;
                                                           }
                                   }

                          stoptimeM=millis() +150;
                                                 }
           
//free space counting

  if (space==0){S1=0;     //if space is 0 go to S10
               }
  if (space==max){S2=0;     //if smace is max go to and S20                  
                 }

  if (S1==0){if (space!=0){S1=1;      //if space is not 0 go to S11
                          }
            }    
  if (S2==0){if (space!=max){S2=1;      //if space is not max go to S21
                           }
            }        

//entry

  if (S1==1){s1S=!digitalRead(s1Pin);      //read state of sensor 1
             if (s1S) {S1=2;               //if sensor 1 is pressed go to S12
                      }
            }   

  if (S1==2){//keyboard
             if (K==1){char key = keypad.getKey();      //read pressed key
                       if (key=='*'){R=0;               //if you press key go to R0 and K2
                                     K=2;
                                    }
                      } 

             if (K==2){char key = keypad.getKey();      //read pressed key
                       L1=1;
                       if (key){A=key;                  //if you press key write key to A and go to K3
                                K=3;
                               }
                      }

             if (K==3){char key = keypad.getKey();      //read pressed key
                       if (key){B=key;                  //if you press key, write key to B and go to K4
                                K=4;
                               }
                      }

             if (K==4){char key = keypad.getKey();      //read pressed key
                       if (key){C=key;                  //if you press key, write key to C and go to K5
                                K=5;
                               }
                      }

             if (K==5){char key = keypad.getKey();      //read pressed key
                       if (key){D=key;                  //if you press key, write key to D and go to K6
                                K=6;
                               }
                      }
             if (K==6){char key = keypad.getKey();      //if you press key # go to K7
                       if (key=='#'){K=7;
                       }
                      }

             if (K==7){if(A==pas1 & B==pas2 & C==pas3 & D==pas4){stoptime1=millis() +15;      //if pasword is corect start timer 15ms, set typed password to blank, go to L12, R1, K1 and S13                                                       
                                                                 A='_';
                                                                 B='_';
                                                                 C='_';
                                                                 D='_';
                                                                 L1=2;
                                                                 R=1;
                                                                 K=1;
                                                                 S1=3;
                                                                }
                       else{A='_';                                                               //if password is incorect set typed password to blank, go to L13, R1 and K1
                            B='_';
                            C='_';
                            D='_';
                            L1=3;
                            R=1;
                            K=1;
                           }
                      }
                      
             s1S=!digitalRead(s1Pin);      //read state of sensor 1
             if (!s1S) {A='_';             //if sensor 1 is released set typed password to blank, end comunication, secure, go to L10, R1, K1 and S11
                        B='_';
                        C='_';
                        D='_';
                        rfid.PICC_HaltA();
                        rfid.PCD_StopCrypto1();
                        L1=0;
                        R=1;
                        K=1;
                        S1=1;            
                       }
             
             //RFID
             if(R==1){if (!rfid.PICC_IsNewCardPresent()){return;     //if tag isn't scaned reset void loop
                                                        }
                      if (!rfid.PICC_ReadCardSerial()){return;
                                                      }
                      else{K=0;          //if tag is scanned go to K0 and R2
                           R=2;            
                          }
                     }

             if(R==2){if(rfid.uid.uidByte[0] == 0x7C & rfid.uid.uidByte[1] == 0xF3 & rfid.uid.uidByte[2] == 0x94 & rfid.uid.uidByte[3] == 0x15) {iR=2;                        //if tag Hex is correct iR is 2, end comunication, secure and go to L21, K1, R1 and S13                                                                                                                              
                                                                                                                                                 rfid.PICC_HaltA();
                                                                                                                                                 rfid.PCD_StopCrypto1();
                                                                                                                                                 L2=1;
                                                                                                                                                 K=1;
                                                                                                                                                 R=1;
                                                                                                                                                 S1=3;
                                                                                                                                                }
                      else{iR=1;                        //if tag hex is incorrect iR is 1, end comunication, secure and go to L22, K1 and R1
                           rfid.PICC_HaltA();
                           rfid.PCD_StopCrypto1();
                           L2=2;
                           K=1;
                           R=1;
                          }
                     }

            }

  if (S1==3){if(millis()>=stoptime1){pos1=pos1+1;                 //if timer 1 reached 0 add 2 to position 1, move servo to positon 1, start timer 1 15ms and go to S13
                                     myservo1.write(pos1);        
                                     stoptime1=millis() +15;     
                                     S1=3;
                                    }
             if(pos1==90){digitalWrite(ledPinG1, 1);     //if position 1 is 90 turn green LED 1 ON, turn red LED 1 OFF and go to S14
                          digitalWrite(ledPinR1, 0);
                          S1=4;            
                         }
            }
           
  if (S1==4){c1S=!digitalRead(c1Pin);      //read state of control sensor 1
             if (c1S) {S1=5;               //if control sensor 1 is pressed go to S15
                      }
            }

  if (S1==5){c1S=!digitalRead(c1Pin);                  //read state of control sensor 1
             if (!c1S) {stoptime1=millis() +1000;      //if control sensor 1 is released start timer 1 1000ms and go to S16
                        S1=6;
                       }
            }

  if (S1==6){c1S=!digitalRead(c1Pin);      //read state of control sensor 1
             if (c1S) {S1=5;               //if control sensor 1 is pressed go to S15
                      }
             if (millis()>=stoptime1) {stoptime1=millis() +15;          //if timer 1 reached 0 start timer 1 15ms, turn green LED 1 OFF, turno red LED 1 and go to S17
                                       digitalWrite(ledPinG1, 0);
                                       digitalWrite(ledPinR1, 1);
                                       S1=7;
                                      }
            }

  if (S1==7){if(millis()>=stoptime1){pos1=pos1-1;                 //if timer 1 reached 0 subtract 2 from position 1, move servo to position 1, start timer 1 15ms and go to S17
                                     myservo1.write(pos1);        
                                     stoptime1=millis() +15;     
                                     S1=7;
                                    }
            
             if(pos1==0){space=space-1;     //if position 1 is 0 substract 1 from space and go to S11
                         S1=1;              
                        }
            }

//exit

  if (S2==1){s2S=!digitalRead(s2Pin);      //read state of sensor 2
             if (s2S) {S2=2;               //if sensor 2 is pressed go to S22
                      }
            }

  if (S2==2){b2S=!digitalRead(b2Pin);              //read state of button 2
             if (b2S) {stoptime2=millis() +15;     //if button 2 is pressed start timer 2 15ms and go to S23
                       S2=3;
                       }
             s2S=!digitalRead(s2Pin);      //read state of sensor 2
             if (!s2S) {S2=1;              //if sensor 2 is released go to S21        
                       }
            }

  if (S2==3){if(millis()>=stoptime2){pos2=pos2+1;                 //if timer 2 reached 0 add 2 to position 2, move servo to positon 2, start timer 2 15ms and go to S23
                                     myservo2.write(pos2);        
                                     stoptime2=millis() +15;     
                                     S2=3;
                                    }
             if(pos2==90){digitalWrite(ledPinG2, 1);     //if position 2 is 90 turn green LED 2 ON, turn red LED2 OFF and go to S24
                          digitalWrite(ledPinR2, 0);
                          S2=4;           
                         }
           }
           
  if (S2==4){c2S=!digitalRead(c2Pin);      //read state of control sensor 2
             if (c2S) {S2=5;               //if control sensor 2 is pressed go to S25
                      }
            }

  if (S2==5){c2S=!digitalRead(c2Pin);                  //read state of control sensor 2
             if (!c2S) {stoptime2=millis() +1000;      //if control sensor 2 is released start timer 2 1000ms and go to S26
                        S2=6;
                       }
            }

  if (S2==6){c2S=!digitalRead(c2Pin);      //read state of control sensor 2
             if (c2S) {S2=5;               //if control sensor 2 is pressed go to S25
                      }
             if (millis()>=stoptime2) {stoptime2=millis() +15;          //if timer 2 reached 0 start timer 2 15ms, turn green LED 2 OFF, turno red LED 2 and go to S27
                                       digitalWrite(ledPinG2, 0);
                                       digitalWrite(ledPinR2, 1);
                                       S2=7;
                                      }
            }

  if (S2==7){if(millis()>=stoptime2){pos2=pos2-1;                 //if timer 2 reached 0 subtract 2 from position 2, move servo to position 2, start timer 2 15ms and go to S27
                                     myservo2.write(pos2);        
                                     stoptime2=millis() +15;     
                                     S2=7;
                                    }
            
             if(pos2==0){space=space+1;     //if position 2 is 0 add 1 to space and go to S21
                         S2=1;             
                        }
            }

 if ( myRadio.available()) {
    while (myRadio.available()){
      myRadio.read( &dataRecieve, sizeof(dataRecieve) );
    }
    Serial.println("Recieve: ");
    Serial.print("Package:");
    Serial.print(dataRecieve.id);
    Serial.print("\n");
    Serial.println(dataRecieve.variable);
    Serial.println(dataRecieve.text);
    Serial.print("\n");
  }

  delay(2000);

  myRadio.stopListening();
  dataTransmit.id = dataTransmit.id + 1;
  dataTransmit.variable = dataTransmit.variable+1;
  Serial.println("Transmit: ");
  Serial.print("Package:");
  Serial.print(dataTransmit.id);
  Serial.print("\n");
  Serial.println(dataTransmit.variable);
  Serial.println(dataTransmit.text);
  Serial.print("\n");
  myRadio.openWritingPipe(addresses[0]);
  myRadio.write(&dataTransmit, sizeof(dataTransmit));
  myRadio.openReadingPipe(1, addresses[0]);
  myRadio.startListening();


}

void export1() {
  HttpClient client;
  int inBuffer = 0;
  client.get("http://www.tulkasa.cz/data/export.php");
  while (client.available()) {buffer[inBuffer] = client.read(); inBuffer++;}
  }

void pname() {
if(buffer[dil] == '1'){
    pcolor = "cervena";
  }
  else if(buffer[dil] == '2'){
    pcolor = "zelena";  
  }
  else if(buffer[dil] == '3'){
    pcolor = "modra";
  }
  else if(buffer[dil] == '4'){
    pcolor = "zluta";
  }
}


