unit O_Prog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm3 = class(TForm)
    B_OK: TButton;
    L_Verze: TLabel;
    Shape1: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    L_Lic: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    Shape2: TShape;
    procedure B_OKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure PrectiVerziSW(const Jmeno: string; var V1, V2, V3, V4: Byte);
  end;

var
  Form3: TForm3;

implementation

{$R *.DFM}

procedure TForm3.PrectiVerziSW(const Jmeno: string; var V1, V2, V3, V4: Byte);
var
  VerInfoSize: Cardinal;
  VerValueSize: Cardinal;
  Dummy: Cardinal;
  PVerInfo: Pointer;
  PVerValue: PVSFixedFileInfo;
begin
  V1 := 0;
  V2 := 0;
  V3 := 0;
  V4 := 0;
  VerInfoSize := GetFileVersionInfoSize(PChar(Jmeno), Dummy);
  GetMem(PVerInfo, VerInfoSize);
  try
    if GetFileVersionInfo(PChar(Jmeno), 0, VerInfoSize, PVerInfo) then
      if VerQueryValue(PVerInfo, '\', Pointer(PVerValue), VerValueSize) then
      begin
        V1 := Byte(HiWord(PVerValue^.dwFileVersionMS));  // Major;
        V2 := Byte(LoWord(PVerValue^.dwFileVersionMS));  // Minor
        V3 := Byte(HiWord(PVerValue^.dwFileVersionLS));  // Release
        V4 := Byte(LoWord(PVerValue^.dwFileVersionLS));  // Build;
      end;
{
        with PVerValue^ do
          Result := Format('v%d.%d.%d build %d', [
            HiWord(dwFileVersionMS), //Major
            LoWord(dwFileVersionMS), //Minor
            HiWord(dwFileVersionLS), //Release
            LoWord(dwFileVersionLS)]); //Build
}
  finally
    FreeMem(PVerInfo, VerInfoSize);
  end;
end;

procedure TForm3.B_OKClick(Sender: TObject);
begin
  ModalResult := mrOK;
end;

procedure TForm3.FormCreate(Sender: TObject);
var
  V1, V2, V3, V4: Byte;
begin
  try
    PrectiVerziSW(Application.ExeName, V1, V2, V3, V4);
  except
    V1 := 1;
    V2 := 1;
    V3 := 0;
    V4 := 0;
  end;
  L_Verze.Caption := 'Verze: ' + Format('%d.%d.%d.%d', [V1, V2, V3, V4]) + ', 2023 - 2025';
  L_Verze.Left    := (Form3.ClientWidth - L_Verze.Width) div 2;
  L_Lic.Caption   := 'Licence: pouze pro intern potebu v rmci projektu "digiBeton"' +
               #13#10'  (TAR TREND, projekt ID: FW06010422)' +
               #13#10'  Nen ureno pro komern pouit!'#13#10 +
               #13#10'License: only for internal use within the ''digiBeton'' project' +
               #13#10'  (TACR TREND, project ID: FW06010422)' +
               #13#10'  Not for commercial use!';
  L_Lic.Left      := (Form3.ClientWidth - L_Lic.Width) div 2;
  B_OK.Top        := L_Lic.Top + L_Lic.Height + 20;
  Form3.ClientHeight := B_OK.Top + B_OK.Height + 20;
end;

procedure TForm3.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then
    ModalResult := mrCancel;
end;

end.
